## Range Operator

MDX range operator (:).




### Description

Returns a set made of the members between the both specified members (specified members included).

Both parameters must specify members within the same level of a given dimension. If the first member is `NULL` then the first member of the level (as specified by the second member) is used. If the second member is `NULL then the last member of the level (as specified by the first member) is used.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member : member

</div>

<div class="ic3-mdx-example-body" style="display:none">

All the months between [Time].[Month].[Jan 2011] and [Time].[Month].[Apr 2011] are returned.

**Query**

```
[Time].[Month].[Jan 2011] : [Time].[Month].[Apr 2011]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jan 2011], 
  [Time].[Calendar].[Month].[Feb 2011], 
  [Time].[Calendar].[Month].[Mar 2011], 
  [Time].[Calendar].[Month].[Apr 2011]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
{
[Time].[Month].[Jan 2011],
[Time].[Month].[Feb 2011],
[Time].[Month].[Mar 2011],
[Time].[Month].[Apr 2011]
}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member : NULL

</div>

<div class="ic3-mdx-example-body" style="display:none">

As the second is member is NULL, the last member of the level is used.

In our example, we're returning all the month of the year 2011.

**Query**

```
[Time].[Month].[Jan 2011] : NULL
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jan 2011], 
  [Time].[Calendar].[Month].[Feb 2011], 
  [Time].[Calendar].[Month].[Mar 2011], 
  [Time].[Calendar].[Month].[Apr 2011], 
  [Time].[Calendar].[Month].[May 2011], 
  [Time].[Calendar].[Month].[Jun 2011], 
  [Time].[Calendar].[Month].[Jul 2011], 
  [Time].[Calendar].[Month].[Aug 2011], 
  [Time].[Calendar].[Month].[Sep 2011], 
  [Time].[Calendar].[Month].[Oct 2011], 
  [Time].[Calendar].[Month].[Nov 2011], 
  [Time].[Calendar].[Month].[Dec 2011]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
{
[Time].[Month].[Jan 2011],
[Time].[Month].[Feb 2011],
[Time].[Month].[Mar 2011],
[Time].[Month].[Apr 2011],
[Time].[Month].[May 2011],
[Time].[Month].[Jun 2011],
[Time].[Month].[Jul 2011],
[Time].[Month].[Aug 2011],
[Time].[Month].[Sep 2011],
[Time].[Month].[Oct 2011],
[Time].[Month].[Nov 2011],
[Time].[Month].[Dec 2011]
}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NULL : member

</div>

<div class="ic3-mdx-example-body" style="display:none">

As the first is member is NULL, the first member of the level is used.

In our example, we're returning all the month of the year 2010.

**Query**

```
NULL : [Time].[Month].[Dec 2010]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jan 2010], 
  [Time].[Calendar].[Month].[Feb 2010], 
  [Time].[Calendar].[Month].[Mar 2010], 
  [Time].[Calendar].[Month].[Apr 2010], 
  [Time].[Calendar].[Month].[May 2010], 
  [Time].[Calendar].[Month].[Jun 2010], 
  [Time].[Calendar].[Month].[Jul 2010], 
  [Time].[Calendar].[Month].[Aug 2010], 
  [Time].[Calendar].[Month].[Sep 2010], 
  [Time].[Calendar].[Month].[Oct 2010], 
  [Time].[Calendar].[Month].[Nov 2010], 
  [Time].[Calendar].[Month].[Dec 2010]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
{
[Time].[Month].[Jan 2010],
[Time].[Month].[Feb 2010],
[Time].[Month].[Mar 2010],
[Time].[Month].[Apr 2010],
[Time].[Month].[May 2010],
[Time].[Month].[Jun 2010],
[Time].[Month].[Jul 2010],
[Time].[Month].[Aug 2010],
[Time].[Month].[Sep 2010],
[Time].[Month].[Oct 2010],
[Time].[Month].[Nov 2010],
[Time].[Month].[Dec 2010]
}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member(level1) : member(level2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using range function with members of different levels will generate an error.

**Query**

```
[Time].[Year].[2010] : [Time].[Month].[Dec 2010]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_RANGE_OPERATOR_MEMBER_LEVEL_MISMATCH](icCubeError.md#olap_range_operator_member_level_mismatch)</td></tr><tr><td>Error Message</td><td>

range '[Time].[Calendar].[Year].&[2010]' : '[Time].[Calendar].[Month].&[DEC 2010]' error : level mismatch</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member : same member

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the same member is used for both parameters a set with the member is returned.

**Query**

```
[Time].[Month].[Dec 2010] : [Time].[Month].[Dec 2010]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Dec 2010]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
{
[Time].[Month].[Dec 2010]
}
```


 
</div>

                                                                         

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
